import { connect } from 'react-redux';
import isPromise from 'is-promise';
import SubAccounts from '../components/SubAccounts';
import * as actions from '../actions';
import { getSubAccounts } from '../../../selectors';

// TODO: нужно положить в более подходящее место
const getFeature = (state, featureName) => state.root.info.features[featureName];

const mapStateToProps = (state) => ({
  items: getSubAccounts(state),
  comDepMoney: getFeature(state, 'comDepMoney'),
});

export default connect(mapStateToProps, (dispatch, props) => ({
  accountDetach: (subAccountId) => {
    const result = dispatch(
      actions.accountDetach(props.accountId, subAccountId, props.onSubmitSuccess),
    );

    if (isPromise(result)) {
      return result.then((data) => {
        const { onSubmitSuccess } = props;

        if (typeof onSubmitSuccess === 'function') {
          onSubmitSuccess();
        }

        return data;
      });
    }

    return result;
  },
}))(SubAccounts);
