import React from 'react';
import PropTypes from 'prop-types';
import { TagsManage as Tags, TagAuthor, apiAccount as apiTags } from 'modules/tags';

const ClientTags = (props) => {
  const {
    id,
    ...passPropsThrough
  } = props;
  const tagsName = `Client${id}`;

  return (
    <Tags
      name={tagsName}
      getTags={() => apiTags.get()}
      addTag={tagId => apiTags.add(id, tagId)}
      removeTag={tagId => apiTags.remove(id, tagId)}
      tagComponent={TagAuthor}
      canCreate={false}
      {...passPropsThrough}
    />
  );
};

ClientTags.propTypes = {
  id: PropTypes.number.isRequired,
};

export default ClientTags;
