import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import Block from 'pages/accounts/modules/info/components/Block';
import ClientInput from 'pages/accounts/modules/info/modules/info/components/ClientInput';
import createI18N from '@yandex-int/i18n';
import * as keyset from './yaTelephonyInfo.i18n';

const i18n = createI18N(keyset);
const i18nTitle = i18n('title');
const i18nContractNum = i18n('contractNum');
const i18nWorkPhoneNum = i18n('workPhoneNum');
const i18nClientStatus = i18n('clientStatus');
const i18nServicePlan = i18n('servicePlan');
const i18nPlanStartDate = i18n('planStartDate');
const i18nTrialStartDate = i18n('trialStartDate');
const i18nClientType = i18n('clientType');
const i18nCCContractNum = i18n('CCContractNum');
const i18nCCWorkPhoneNum = i18n('CCWorkPhoneNum');
const i18nCCContractStatus = i18n('CCContractStatus');
const i18nMTTContractNum = i18n('MTTContractNum');
const i18nMTTWorkPhoneNum = i18n('MTTWorkPhoneNum');
const i18nMTTContractStatus = i18n('MTTContractStatus');
const i18nAddress = i18n('address');

const YaTelephonyInfo = props => {
  const {
    data: {
      contractNumber,
      workPhoneNumber,
      status,
      servicePlan,
      address,
      servicePlanStartDate,
      trialStartDate,
      contractType,
      contractNumberCC,
      businessPhoneNumberCC,
      contractStateCC,
      contractNumberMTT,
      businessPhoneNumberMTT,
      contractStateMTT,
    },
    access,
    accessFields,
  } = props;
  return (
    <Block title={i18nTitle} access={access} color="#66C7FF">
      <ClientInput
        labelText={i18nContractNum}
        value={contractNumber}
        access={accessFields.contractNumber}
        preview
      />
      <ClientInput
        labelText={i18nWorkPhoneNum}
        value={workPhoneNumber}
        access={accessFields.workPhoneNumber}
        preview
      />
      <ClientInput
        labelText={i18nClientStatus}
        value={status}
        access={accessFields.status}
        preview
      />
      <ClientInput
        labelText={i18nServicePlan}
        value={servicePlan}
        access={accessFields.servicePlan}
        preview
      />
      <ClientInput
        labelText={i18nPlanStartDate}
        value={
          servicePlanStartDate ? (
            <FormattedDate
              value={new Date(servicePlanStartDate)}
              year="numeric"
              month="numeric"
              day="numeric"
              hour="numeric"
              minute="numeric"
            />
          ) : (
            undefined
          )
        }
        access={accessFields.servicePlanStartDate}
        preview
      />
      <ClientInput
        labelText={i18nTrialStartDate}
        value={
          trialStartDate ? (
            <FormattedDate
              value={new Date(trialStartDate)}
              year="numeric"
              month="numeric"
              day="numeric"
              hour="numeric"
              minute="numeric"
            />
          ) : (
            undefined
          )
        }
        access={accessFields.trialStartDate}
        preview
      />
      <ClientInput
        labelText={i18nClientType}
        value={contractType}
        access={accessFields.contractType}
        preview
      />
      <ClientInput
        labelText={i18nCCContractNum}
        value={contractNumberCC}
        access={accessFields.contractNumberCC}
        preview
      />
      <ClientInput
        labelText={i18nCCWorkPhoneNum}
        value={businessPhoneNumberCC}
        access={accessFields.businessPhoneNumberCC}
        preview
      />
      <ClientInput
        labelText={i18nCCContractStatus}
        value={contractStateCC}
        access={accessFields.contractStateCC}
        preview
      />
      <ClientInput
        labelText={i18nMTTContractNum}
        value={contractNumberMTT}
        access={accessFields.contractNumberMTT}
        preview
      />
      <ClientInput
        labelText={i18nMTTWorkPhoneNum}
        value={businessPhoneNumberMTT}
        access={accessFields.businessPhoneNumberMTT}
        preview
      />
      <ClientInput
        labelText={i18nMTTContractStatus}
        value={contractStateMTT}
        access={accessFields.contractStateMTT}
        preview
      />
      <ClientInput labelText={i18nAddress} value={address} access={accessFields.address} preview />
    </Block>
  );
};

YaTelephonyInfo.propTypes = {
  data: PropTypes.instanceOf(Object),
  access: PropTypes.number,
  accessFields: PropTypes.instanceOf(Object),
};

YaTelephonyInfo.defaultProps = {
  data: {},
  access: 0,
  accessFields: {},
};

export default YaTelephonyInfo;
