import * as aTypes from './actionTypes';

const INIT_STATE = {};

const behaviors = {
  [aTypes.REQUEST_LOAD](state) {
    return {
      ...state,
      isFetch: true,
    };
  },
  [aTypes.RECEIVE_LOAD](state, { data }) {
    return {
      ...state,
      isFetch: false,
      isLoad: true,
      data,
    };
  },
  [aTypes.FAILED_LOAD](state) {
    return {
      ...state,
      isFetch: false,
    };
  },
  [aTypes.RECEIVE_EDIT](state, { args }) {
    return {
      ...state,
      data: {
        ...state.data,
        info: {
          ...state.data?.info,
          ...args,
        },
      },
    };
  },
  [aTypes.DESTROY]() {
    return INIT_STATE;
  },
  [aTypes.ADD_CONTACT](state, { payload }) {
    return {
      ...state,
      data: {
        ...state.data,
        contacts: {
          ...state.data.contacts,
          items: [payload].concat(state.data.contacts.items),
        },
      },
    };
  },
  [aTypes.UPDATE_CONTACT](state, { payload }) {
    return {
      ...state,
      data: {
        ...state.data,
        contacts: {
          ...state.data.contacts,
          items: state.data.contacts.items.map((item) =>
            item.contactId === payload.contactId ? payload : item,
          ),
        },
      },
    };
  },
  [aTypes.RECEIVE_REMOVE_CONTACT](state, { args }) {
    return {
      ...state,
      data: {
        ...state.data,
        contacts: {
          ...state.data.contacts,
          items: state.data.contacts.items.filter((item) => item.contactId !== args.contactId),
        },
      },
    };
  },
};

const reducer = (state = INIT_STATE, action) => {
  const behavior = behaviors[action.type];
  const newState = behavior ? behavior(state, action) : state;

  return newState;
};

export default reducer;
