import { initialize } from 'redux-form';
import { jsonApiCall, get } from 'api/common';
import { actions as listActions } from 'containers/InfiniteList';
import * as aTypes from './actionTypes';
import { FORM } from './constants';
import { getState as getFilterState } from './selectors';

export const initializeForm = (filter) => initialize(FORM, filter);

export const loadFilter = (filterId) => (dispatch, getState) =>
  dispatch({
    type: 'PROMISE',
    actions: [aTypes.FILTER_REQUEST, aTypes.FILTER_RECEIVE, aTypes.FILTER_FAIL],
    promise: get({
      url: '/view/account/filter',
      data: { filterId },
    }).then((response) => {
      let meta;
      try {
        meta = JSON.parse(response.meta);
      } catch (e) {
        console.error(e);
      }

      let filter;
      try {
        // set url filter
        const state = getFilterState(getState());
        if (!state.isInit && state.lastArgs.filter) {
          ({ filter } = state.lastArgs);
        }
      } catch (e) {
        // empty catch
      }

      if (!filter) {
        filter = response.filter || {};
        filter.name = response.filterName;
        filter.id = response.filterId;
      }

      dispatch(
        initializeForm({
          ...filter,
          tier: [],
          service: [],
        }),
      );

      return { ...response, filter, meta };
    }),
  });

export const setFilter = (filter) => (dispatch) => {
  dispatch({ type: aTypes.SET_FILTER, payload: filter });
  if (typeof filter === 'number') {
    dispatch(loadFilter(filter));
  }
};

export const setFilterNew = () => initialize(FORM, { filter: {} });

export const updateList = () => listActions.reload('clients');

export const loadClients = (data) => () =>
  jsonApiCall({
    data,
    url: '/view/client/list',
    global: false,
  });

export const destroy = () => ({ type: aTypes.DESTROY });

export const setSelectedAccounts = (id) => (dispatch) => {
  dispatch({ type: aTypes.SELECT_ACCOUNT, payload: id });
};

export const setSelectedAllAccounts = (selectAll) => (dispatch) => {
  dispatch({ type: aTypes.SELECT_ALL_ACCOUNTS, payload: selectAll });
};
