import * as React from 'react';
import reduxComponents from 'lego/redux-form';
import FastCheckBox from 'lego/redux-form/FastCheckBox';
import { Field } from 'redux-form';
import fields from './Fields';
import Range from './Range';
import css from './styles.modules.scss';

interface Props {
  size?: string;
  theme?: string;
  children?: React.ReactNode;
  name: string;
  component: string;
  hint: string;
  label: React.ReactNode;
}

const patchedReduxComponents = {
  ...reduxComponents,
  CheckBox: FastCheckBox,
};

delete patchedReduxComponents.AccountInput;

const withFieldComponents = {
  Range,
  ...fields,
};

const FilterField = (props: Props) => {
  const { label, component, hint, ...passPropsThrough } = props;

  let renderedLabel;
  if (hint) {
    renderedLabel = (
      <span title={hint} className={css.label_hint}>
        {label}
      </span>
    );
  } else {
    renderedLabel = label;
  }

  let renderComponent;
  if (patchedReduxComponents[component]) {
    if (component === 'CheckBox') {
      passPropsThrough.size = 's';
      passPropsThrough.theme = undefined;
      passPropsThrough.children = renderedLabel;
    }

    renderComponent = <Field component={patchedReduxComponents[component]} {...passPropsThrough} />;
  } else if (withFieldComponents[component]) {
    renderComponent = React.createElement(withFieldComponents[component], passPropsThrough);
  }

  if (component === 'CheckBox') {
    return <div className={css.row}>{renderComponent}</div>;
  }

  return (
    <div className={css.row}>
      <span className={`${css.label} ${css.label_type_main}`}>{renderedLabel}</span>
      <div className={css.field}>{renderComponent}</div>
    </div>
  );
};

export default FilterField;
