import React from 'react';
import PropTypes from 'prop-types';
import { Field, propTypes } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import TextInput from 'lego/redux-form/TextInput';
import Toolbar from 'components/Toolbar';
import * as keyset from './FilterForm.i18n';
import css from './styles.modules.scss';
import Filters from './FiltersContainer';

const i18n = createI18N(keyset);
const i18nSave = createI18N(commonKeyset)('save');
const i18nSaveAsNew = i18n('saveAsNew');
const i18nApply = i18n('apply');
const i18nFilterName = i18n('filterName');

const FiltersForm = (props) => {
  const { className, handleSubmit, error, valid, filterName, filterId, save, saveAsNew } = props;

  const handleSaveClick = handleSubmit(save);
  const handleSaveAsNewClick = handleSubmit(saveAsNew);

  return (
    <form className={cx(className, css.root)} onSubmit={handleSubmit}>
      <Toolbar className={css.actions_header}>
        <Button view="pseudo" size="xs" disabled={!valid || !filterName} onClick={handleSaveClick}>
          {i18nSave}
        </Button>
        {filterId && (
          <Button
            view="pseudo"
            size="xs"
            onClick={handleSaveAsNewClick}
            disabled={!valid || !filterName}
          >
            {i18nSaveAsNew}
          </Button>
        )}
        <Button view="action" disabled={!valid} size="xs" type="submit">
          {i18nApply}
        </Button>
      </Toolbar>
      {error && (
        <div className={css.error_global}>
          <div className={css.error_global__message}>{error}</div>
        </div>
      )}
      <div className={css.nameWrap}>
        <Field
          className={css.field}
          name="name"
          component={TextInput}
          size="xs"
          placeholder={i18nFilterName}
        />
      </div>
      <Filters />
    </form>
  );
};

FiltersForm.propTypes = {
  ...propTypes,
  className: PropTypes.string,
  change: PropTypes.func.isRequired,
  filterType: PropTypes.arrayOf(PropTypes.string),
  me: PropTypes.shape({
    id: PropTypes.number,
    name: PropTypes.string,
  }),
  members: PropTypes.arrayOf(
    PropTypes.shape({
      id: PropTypes.number,
      name: PropTypes.string,
    }),
  ),
  managerId: PropTypes.number,
  error: PropTypes.string,
  filterName: PropTypes.string,
  save: PropTypes.func.isRequired,
  saveAsNew: PropTypes.func.isRequired,
};

FiltersForm.defaultProps = {
  className: undefined,
  filterType: [],
  filterName: '',
  me: {},
  members: [],
  managerId: undefined,
  error: undefined,
};

export default FiltersForm;
