import { connect } from 'react-redux';
import { save, saveAsNew } from 'pages/accounts/modules/filtersList';
import { reduxForm, formValueSelector } from 'redux-form';
import FilterForm from './FilterForm';

const mapState = (state, props) => {
  const selector = formValueSelector(props.form);

  return {
    filterName: selector(state, 'name'),
    filterId: selector(state, 'id'),
  };
};

export default connect(
  mapState,
  { save, saveAsNew },
)(reduxForm()(FilterForm));
