import React from 'react';
import { connect } from 'react-redux';
import FilterFormContainer from './FilterFormContainer';
import { loadFilter } from '../../actions';

class FilterLoader extends React.Component {
  componentDidMount() {
    this.props.loadFilter(this.props.filterId);
  }

  componentDidUpdate(prevProps) {
    if (this.props.filterId !== prevProps.filterId) {
      this.props.loadFilter(this.props.filterId);
    }
  }

  render() {
    return React.createElement(FilterFormContainer, this.props);
  }
}

export default connect(
  null,
  { loadFilter },
)(FilterLoader);
