import * as React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import ReactBuilder from 'components/ReactBuilder';
import createI18N from '@yandex-int/i18n';
import Icon from '@crm/components/dist/lego2/Icon';
import { ProviderGroup } from 'modules/groups';
import * as keyset from './FilterForm.i18n';
import css from './Filters.scss';
import metaJson from './meta';

const i18nFilterSearch = createI18N(keyset)('filterSearch');

interface Props {
  // eslint-disable-next-line  @typescript-eslint/no-explicit-any
  meta: any;
  search: string;
  onSearch: (value: string) => {};
  isSearch: boolean;
}

const Filters = (props: Props) => {
  const { meta, search, onSearch, isSearch } = props;

  return (
    <div className={css.b}>
      <div className={css.b__header}>
        <Textinput
          placeholder={i18nFilterSearch}
          value={search}
          iconRight={<Icon svg="loupe" />}
          onChange={onSearch}
        />
      </div>
      <ProviderGroup name="filter" show={isSearch}>
        {React.createElement(ReactBuilder, { meta, components: metaJson.components })}
      </ProviderGroup>
    </div>
  );
};

export default Filters;
