import * as React from 'react';
import { connect } from 'react-redux';
import escapeRegExp from 'lodash/escapeRegExp';
import debounce from 'lodash/debounce';
import filterTree from 'utils/filterTree';
import Filters from './Filters';
import { getFilterMeta } from '../../selectors';

interface Props {
  meta: any;
}

interface State {
  meta: any;
  isSearch: boolean;
  search: string;
}

class FiltersContainer extends React.Component<Props, State> {
  constructor(props) {
    super(props);

    this.filter = debounce(this.filter, 200);
    this.state = {
      search: '',
      meta: props.meta,
      isSearch: false,
    };
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.meta !== this.props.meta) {
      this.setState({
        search: '',
        meta: nextProps.meta,
        isSearch: false,
      });
    }
  }

  handleSearch = value => {
    this.setState({ search: value });
    this.filter(value);
  };

  filter = value => {
    if (value) {
      const searchPattern = new RegExp(`(${escapeRegExp(value)})`, 'im');

      const predicate = node => {
        const nodeProps = (node && node.props) || {};
        return node.component === 'Field' && searchPattern.test(nodeProps.label);
      };

      const newMeta = filterTree({ node: this.props.meta, predicate });

      this.setState({ meta: newMeta, isSearch: true });
    } else {
      this.setState({ meta: this.props.meta, isSearch: false });
    }
  };

  render() {
    return React.createElement(Filters, { ...this.state, onSearch: this.handleSearch });
  }
}

export default connect(state => ({ meta: getFilterMeta(state) }))(FiltersContainer);
