import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import FastTextInput from 'lego/redux-form/FastTextInput';
import { Field } from 'redux-form';
import createI18N from '@yandex-int/i18n';
import * as keyset from './FilterForm.i18n';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const i18nFrom = i18n('from');
const i18nTo = i18n('to');

const Range = props => {
  const { name, errorPlacement } = props;

  return (
    <span className={css.rangeGroup}>
      <span className={css.label}>{i18nFrom}</span>
      <Field
        className={cx(css.field, css.input)}
        classNameInput={css.inputWrap}
        name={`${name}.from`}
        component={FastTextInput}
        size="xs"
        errorPlacement={errorPlacement}
      />
      <span className={css.label}>{i18nTo}</span>
      <Field
        className={cx(css.field, css.input)}
        classNameInput={css.inputWrap}
        name={`${name}.to`}
        component={FastTextInput}
        size="xs"
        errorPlacement={errorPlacement}
      />
    </span>
  );
};

Range.propTypes = {
  name: PropTypes.string.isRequired,
  errorPlacement: PropTypes.arrayOf(PropTypes.string),
};

Range.defaultProps = {
  errorPlacement: ['top-center'],
};

export default Range;
