import React from 'react';
import { config } from 'services/Config';
import { InfiniteTableView } from 'containers/InfiniteList';
import RowAccount from '../RowAccount';
import css from './Layout.module.css';
import Panel from './Panel';

const ClientPage = (props) => {
  const {
    updateFilter,
    onLoad,
    selectedAllAccounts,
    setSelectedAllAccounts,
    selectedAccounts,
    setSelectedAccounts,
  } = props;

  return (
    <div className={css.root}>
      <Panel updateFilter={updateFilter} />
      <InfiniteTableView
        className={css.list}
        name="clients"
        onLoad={onLoad}
        rowComponent={RowAccount}
        withNavigation={false}
        forceDisplayAllColumns
        saveUI
        canSelect
        showIfEmpty
        headerChecked={selectedAllAccounts}
        onHeaderCheck={config.value.features.massMailImprovements && setSelectedAllAccounts}
        itemsChecked={selectedAccounts}
        onItemCheck={config.value.features.massMailImprovements && setSelectedAccounts}
      />
    </div>
  );
};

export default ClientPage;
