import React, { memo } from 'react';
import Panel from 'modules/panel';
import { PanelScheme, Position } from '@crm/components/dist/Panel';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Layout.i18n';
import FilterForm from '../FilterForm';
import { FORM } from '../../constants';
import css from './Layout.module.css';
import cssPanel from './Panel.module.css';

const i18nFilters = createI18N(keyset)('filters');

interface Props {
  updateFilter: any;
}

const IssuePanel: React.FC<Props> = ({ updateFilter }) => {
  const panels: PanelScheme[] = [];

  panels.push({
    id: 'filters',
    title: i18nFilters,
    content: (
      <div className={cssPanel.b__panel}>
        <FilterForm form={FORM} className={css.filter} onSubmit={updateFilter} />
      </div>
    ),
    keepMount: true,
    padding: false,
  });

  return (
    <Panel
      maxWidth={600}
      name="accounts_page"
      panels={panels}
      position={Position.Left}
      defaultPin
      defaultPanelId="filters"
    />
  );
};

export default memo(IssuePanel);
