/*
eslint-disable
react/style-prop-object,
*/

import React from 'react';
import PropTypes from 'prop-types';
import { FormattedNumber } from 'react-intl';
import isUndefined from 'lodash/isUndefined';
import { Link } from 'react-router-dom';
import cx from 'classnames';
import ClientExternalLinks from 'components/ClientExternalLinks';
import PlainText from 'components/PlainText';
import Tags from 'modules/tags/components/Tags';
import Checkbox from '@crm/components/dist/lego2/Checkbox';
import { accountLink } from 'pages/accounts/utils/linkCreator';
import ExternalLinks from 'components/ExternalLinks';
import css from './styles.modules.scss';

const MONEY_CELL = {
  m1Total: true,
  w0Total: true,
  f30Total: true,
};

const NUMBER_CELL = {
  downtime: true,
};

const PERCENT_CELL = {
  w12pct: true,
  m01pct: true,
};

const ALIGN_RIGHT = {
  m1Total: true,
  w0Total: true,
  f30Total: true,
  w12pct: true,
  m01pct: true,
  downtime: true,
};

const ALIGN_RIGHT_TYPES = {
  money_with_currency: true,
  percent: true,
};

const stopPropagation = (e) => {
  e.stopPropagation();
};

const Row = (props) => {
  const {
    item,
    columns,
    className,
    cellClassName,
    columnsStyle,
    index,
    onClick,
    onDoubleClick,
    isChecked,
    onCheck,
  } = props;

  return (
    <Link
      to={accountLink(item.id)}
      className={cx(className, css.root)}
      onClick={onClick}
      onDoubleClick={onDoubleClick}
    >
      {onCheck && (
        <span
          role="presentation"
          onClick={stopPropagation}
          className={cellClassName}
          style={columnsStyle && columnsStyle.checked}
        >
          <Checkbox checked={isChecked} onChange={onCheck} />
        </span>
      )}
      <div className={cellClassName} style={columnsStyle && columnsStyle.index}>
        {index}
      </div>
      {columns.map((column) => {
        const value = item[column.name];
        const { type: columnType } = column;

        let result;

        if (value === true) {
          result = <i className="fa fa-check" aria-hidden="true" />;
        } else if (!isUndefined(value)) {
          if (columnType === 'money_with_currency') {
            result = (
              <FormattedNumber value={value.value} style="currency" currency={value.currency} />
            );
          } else if (columnType === 'percent') {
            result = (
              <span>
                <FormattedNumber value={value} style="decimal" /> %
              </span>
            );
          } else if (MONEY_CELL[column.name]) {
            result = <FormattedNumber value={value} style="currency" currency="RUB" />;
          } else if (NUMBER_CELL[column.name]) {
            result = <FormattedNumber value={value} style="decimal" />;
          } else if (PERCENT_CELL[column.name]) {
            result = (
              <span>
                <FormattedNumber value={value} style="decimal" /> %
              </span>
            );
          } else if (Array.isArray(value)) {
            result = <Tags className={css.tags} tags={value} />;
          } else if (column.name === 'domain') {
            result = <ExternalLinks value={value} stopPropagation />;
          } else if (column.name === 'comment') {
            result = <PlainText text={value} link />;
          } else if (column.name === 'services') {
            result = (
              <span role="presentation" onClick={stopPropagation}>
                <ClientExternalLinks
                  client={{
                    info: {
                      ...item,
                      type: item.typeCode,
                    },
                    services: item.services,
                  }}
                />
              </span>
            );
          } else {
            result = <span>{value}</span>;
          }
        } else {
          result = <span>&mdash;</span>;
        }

        return (
          <div
            key={column.name}
            className={cx(cellClassName, {
              [css.align_right]: ALIGN_RIGHT[column.name] | ALIGN_RIGHT_TYPES[column.type],
            })}
            style={columnsStyle && columnsStyle[column.name]}
          >
            {result}
          </div>
        );
      })}
    </Link>
  );
};

Row.propTypes = {
  item: PropTypes.objectOf(PropTypes.any).isRequired,
  columns: PropTypes.objectOf(PropTypes.any).isRequired,
  columnsStyle: PropTypes.objectOf(PropTypes.any),
  index: PropTypes.number.isRequired,
  cellClassName: PropTypes.string,
  className: PropTypes.string,
  onClick: PropTypes.func,
  onDoubleClick: PropTypes.func,
};

Row.defaultProps = {
  cellClassName: undefined,
  columnsStyle: undefined,
  className: undefined,
  onClick: undefined,
  onDoubleClick: undefined,
};

export default Row;
