import React from 'react';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import url from 'utils/url';
import { connect } from 'react-redux';
import { NAME } from '../constants';
import reducers from '../reducers';
import * as action from '../actions';
import Layout from '../components/Layout';

global.reduxStore.injectReducer(NAME, reducers);

const mapState = state => ({
  ...get(state, NAME),
});

class ClientPage extends React.Component {
  componentDidMount() {
    const query = url.queryToObject(this.props.location.search);
    const urlFilterObj = get(query, 'filter');

    if (urlFilterObj) {
      this.props.setFilter(urlFilterObj);
    } else {
      this.props.updateList();
    }
  }

  componentDidUpdate(prevProps) {
    if (prevProps.filterHash !== this.props.filterHash) {
      this.props.updateList();
    }
  }

  componentWillUnmount() {
    this.props.destroy();
  }

  handleLoad = args => this.props.loadClients({ ...args, ...this.props.lastArgs });

  render() {
    return <Layout {...this.props} onLoad={this.handleLoad} updateFilter={this.props.setFilter} />;
  }
}

ClientPage.propTypes = {
  filterHash: PropTypes.number.isRequired,
  updateList: PropTypes.func.isRequired,
  setFilter: PropTypes.func.isRequired,
  destroy: PropTypes.func.isRequired,
  loadClients: PropTypes.func.isRequired,
  lastArgs: PropTypes.instanceOf(Object),
};

ClientPage.defaultProps = {
  lastArgs: {},
};

export default connect(
  mapState,
  action,
)(ClientPage);
