import * as aTypes from './actionTypes';

const INIT_STATE = {
  isInit: false, // for support url filter
  filterHash: 0,
  lastArgs: null,
  selectedAccounts: new Set(),
  selectedAllAccounts: false,
};

const behaviors = {
  [aTypes.SET_FILTER](state, { payload }) {
    let { filterHash } = state;
    if (Number.isInteger(filterHash)) {
      filterHash += 1;
    } else {
      filterHash = 0;
    }

    const newLastArgs = {};
    if (typeof payload === 'number') {
      newLastArgs.filterId = payload;
    } else {
      newLastArgs.filter = payload;
    }

    return {
      ...state,
      lastArgs: newLastArgs,
      filterHash,
    };
  },
  [aTypes.FILTER_RECEIVE](state, { data }) {
    const newState = {
      ...state,
      isInit: true,
      filter: data,
    };

    if (!state.lastArgs) {
      try {
        const { filterId, filter } = data;
        if (filterId) {
          newState.lastArgs = { filterId };
        } else if (filter) {
          newState.lastArgs = { filter };
        }
      } catch (e) {
        // empty catch
      }
    }

    return newState;
  },
  [aTypes.SELECT_ACCOUNT](state, { payload }) {
    const newSelectedAccounts = new Set(state.selectedAccounts);
    newSelectedAccounts.has(payload)
      ? newSelectedAccounts.delete(payload)
      : newSelectedAccounts.add(payload);

    return {
      ...state,
      selectedAccounts: newSelectedAccounts,
    };
  },
  [aTypes.SELECT_ALL_ACCOUNTS](state, { payload }) {
    return {
      ...state,
      selectedAllAccounts: payload,
      selectedAccounts: new Set(),
    };
  },
};

const reducer = (state = INIT_STATE, action) => {
  const behavior = behaviors[action.type];
  return behavior ? behavior(state, action) : state;
};

export default reducer;
