import React from 'react';
import TitleChain from 'modules/heading';
import { moduleAuthorization } from 'modules/authorization/moduleAuthorization';
import createI18N from '@yandex-int/i18n';
import * as keyset from './accounts.i18n';
import Layout from './containers/Layout';
import { component as Table } from './modules/table';
import Info from './modules/info';

const i18n = createI18N(keyset);
const i18nAccountsTitle = i18n('accountsTitle');
const i18nAccountTitle = i18n('accountTitle');

const TableWithAuth = moduleAuthorization('accountList')(Table);

export const AccountsRouter = props => (
  <Layout {...props}>
    <TitleChain>{i18nAccountsTitle}</TitleChain>
    <TableWithAuth {...props} />
  </Layout>
);

export const AccountRouter = props => (
  <Layout {...props}>
    <TitleChain>{i18nAccountTitle}</TitleChain>
    <Info {...props} />
  </Layout>
);
