const filterList = (list, needle) => {
  if (!list) return [];

  if (!needle) return list;

  return list.filter((item) => {
    const keys = Object.keys(item);

    delete keys.id;

    return keys.some((key) => {
      return item[key].toString().toLowerCase().search(needle.toString().toLowerCase()) > -1;
    });
  });
};

export default filterList;
