import { PATH_ACCOUNT, PATH_ACCOUNTS } from '../constants';

const accountsRegex = new RegExp(`^(${PATH_ACCOUNT}|${PATH_ACCOUNTS})`);
const accountRegex = /^\/?account(\/|$|\?)/;

export default (path = '') => {
  if (!path || typeof path !== 'string') {
    return false;
  }

  return path.match(accountsRegex);
};

export const isAccountPath = (path = '') => path.match(accountRegex);
