import { setFilter, removeFilter } from 'modules/filter';
import { NAME } from './constants';
import {
  actions as mailListItemActions,
  selectors as mailListItemSelectors,
} from './modules/mailListItem';
import getAccountSearchStr from './utils/getAccountSearchStr';

export const update = () => ({
  type: 'FETCH',
  context: NAME,
  args: {
    url: '/view/mail/list/refresh',
    global: false,
  },
});

export const search = (values, valuesUI) => dispatch => {
  dispatch(
    setFilter(NAME, {
      key: 'search',
      value: values,
      valuesUI: valuesUI || values,
      showFolder: true,
      autoUpdate: false,
    }),
  );
};

export const filterByClient = client =>
  search({
    clientIdLogin: getAccountSearchStr(client),
    folderId: -1,
    scope: 'any',
  });

export const resetFilter = () => dispatch => {
  dispatch(removeFilter(NAME, 'search'));
};

export const save = args => ({
  type: 'FETCH',
  context: NAME,
  args: {
    url: '/actions/mail/save',
    data: args,
    isHandleUnsuccessful: true,
    global: false,
  },
});

export const threadExpand = args => (dispatch, getState) => {
  if (args) {
    let threadId;
    if (typeof args === 'string') {
      threadId = args;
    } else if (typeof args === 'object') {
      threadId = args.id;
    }

    const state = getState();

    const isThreadFetch = mailListItemSelectors.getThreadFetch(state, threadId);
    const threadSize = mailListItemSelectors.getThreadSize(state, threadId);

    if (!isThreadFetch && (threadSize && threadSize > 1)) {
      const url = mailListItemSelectors.getThreadLoad(state, threadId)
        ? '/view/mail/list/thread/collapse'
        : '/view/mail/list/thread/expand';

      dispatch(mailListItemActions.threadRequest(threadId));
      return dispatch({
        type: 'FETCH',
        context: NAME,
        args: {
          url,
          data: { id: threadId },
          isHandleUnsuccessful: true,
        },
      })
        .then(data => {
          dispatch(mailListItemActions.threadReceive(threadId));
          return data;
        })
        .catch(e => {
          dispatch(mailListItemActions.threadFail(threadId));
          throw e;
        });
    }
  }

  return null;
};
