import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import Button from '@crm/components/dist/lego2/Button';
import * as keyset from './FastFilters.i18n';
import css from './styles.modules.scss';
import { IconImportant, IconUnread } from '../Icons';

const i18n = createI18N(keyset);
const i18nImportant = i18n('important');
const i18nUnread = i18n('unread');

const FolderMenu = (props) => {
  const { filtersCounters, filterActive, switchFilter } = props;

  return (
    <div className={css.root}>
      <Button
        title={i18nImportant}
        view="pseudo"
        pin="round-clear"
        checked={filterActive === 'important'}
        onClick={() => {
          switchFilter('important');
        }}
      >
        <IconImportant />
        &nbsp;
        {filtersCounters.important || 0}
      </Button>
      <Button
        title={i18nUnread}
        view="pseudo"
        pin="brick-round"
        checked={filterActive === 'onlyNew'}
        onClick={() => {
          switchFilter('onlyNew');
        }}
      >
        <IconUnread />
        &nbsp;
        {filtersCounters.unread || 0}
      </Button>
    </div>
  );
};

FolderMenu.propTypes = {
  filtersCounters: PropTypes.shape({
    unread: PropTypes.number,
    important: PropTypes.number,
  }),
  filterActive: PropTypes.string,
  switchFilter: PropTypes.func,
};

FolderMenu.defaultProps = {
  filtersCounters: {
    unread: undefined,
    important: undefined,
  },
  filterActive: undefined,
  switchFilter: () => {},
};

export default FolderMenu;
