import React from 'react';
import Select from 'components/Select';
import cx from 'classnames';
import { withRouter } from 'react-router-dom';
import TitleChain from 'modules/heading';
import css from './FolderNode.modules.scss';

const FolderNode = props => {
  const {
    id,
    name,
    counter: { unread },
    searchRange,
    connectDropTarget,
    isOver,
    match,
  } = props;

  const folder = (
    <span className={cx(css.root, { [css.over]: isOver })}>
      {String(match && match.params && match.params.param2) === String(id) && (
        <TitleChain>{name}</TitleChain>
      )}
      <Select className={css.name} value={name} range={searchRange} />
      &nbsp;
      {unread ? (
        <span className={css.count}>
          <span>{unread}</span>
        </span>
      ) : null}
    </span>
  );

  if (typeof connectDropTarget === 'function') {
    return connectDropTarget(folder);
  }

  return folder;
};

export default withRouter(FolderNode);
