import React from 'react';
import PropTypes from 'prop-types';
import FilterTreeView from 'containers/TreeSelect/FilterTreeView';
import connectorTreeView from 'containers/TreeSelect/connectorTreeView';
import cx from 'classnames';
import FolderNode from '../../containers/FolderNode';
import FastFilters from '../../containers/FastFilters';
import css from './styles.modules.scss';
import treeNodeTheme from './treeNodeTheme.modules.scss';
import { NAME } from '../../constants';

const FoldersContainer = connectorTreeView({
  name: NAME,
  endpoint: '/view/mail/folder/list',
  params: {
    dataKey: 'summaryCounter',
  },
  apiDefaultSlug: 'defaultFolderId',
})(FilterTreeView);

const getTheme = (view) => {
  return {
    ...treeNodeTheme,
    root: treeNodeTheme[`root_${view}`],
  };
};

const Folders = ({ className, view, folderId, classNameExtend, popupClassName, ...props }) => (
  <div className={`${className ? css[className] : css[`root_${view}`]} ${classNameExtend}`}>
    <FoldersContainer
      className={cx(css[`folders_${view}`], popupClassName)}
      componentNode={FolderNode}
      clickMode="wrap"
      treeNodeTheme={getTheme(view)}
      selected={folderId}
      enableReinitialize={view === 'default'}
      {...props}
    />
    {view === 'default' && <FastFilters className={css.menu} />}
  </div>
);

Folders.propTypes = {
  className: PropTypes.string,
  classNameExtend: PropTypes.string,
  view: PropTypes.string,
  folderId: PropTypes.number,
  showToolbar: PropTypes.bool,
};

Folders.defaultProps = {
  className: undefined,
  classNameExtend: '',
  folderId: undefined,
  view: 'default',
  showToolbar: false,
};

export default Folders;
