import React, { FC } from 'react';
import { Link } from 'react-router-dom';
import cx from 'classnames';
import cssChips from 'styles/component/chips.scss';
import css from './LinkWithText.scss';
import { LinkWithTextProps } from './LinkWithText.types';

export const LinkWithText: FC<LinkWithTextProps> = ({ className, url, title, linkText, text }) => {
  return (
    <div className={cx(className, css.LinkWithText)} title={title}>
      <Link to={url} target="_blank">
        {linkText}
      </Link>
      <span className={cssChips.chip__title}>{text}</span>
    </div>
  );
};
