import React from 'react';
import threadIdToMailId from 'pages/mail/utils/threadIdToMailId';
import createI18N from '@yandex-int/i18n';
import * as keyset from './Mail.i18n';
import { component as MailBlock } from '../../modules/mailPreview';
import css from './Mail.module.css';

const i18nNotSelected = createI18N(keyset)('notSelected');

interface MailProps {
  threadIdOrMailId: string;
  history: any;
}

export default class MailContainer extends React.Component<MailProps> {
  private newMail = type => args => {
    this.props.history.push({
      pathname: '/mail/new',
      state: { loadArgs: args, type },
    });
  };

  public render() {
    const { threadIdOrMailId } = this.props;
    const mailId = threadIdToMailId(threadIdOrMailId);

    if (mailId) {
      return (
        <MailBlock
          onReply={this.newMail('reply')}
          onDraft={this.newMail('draft')}
          mailId={mailId}
        />
      );
    }

    return (
      <div className={css.root_empty}>
        <span>{i18nNotSelected}</span>
      </div>
    );
  }
}
