import React from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';

const DateComponent = ({ date }) => {
  const displayDate = new Date(date);
  const currentDate = new Date();

  const isCurrentDay = displayDate.getDate() === currentDate.getDate();
  const isCurrentMonth = displayDate.getMonth() === currentDate.getMonth();
  const isCurrentYear = displayDate.getFullYear() === currentDate.getFullYear();

  if (isCurrentDay && isCurrentMonth && isCurrentYear) {
    return (
      <FormattedDate
        value={displayDate}
        hour="numeric"
        minute="2-digit"
      />
    );
  }

  if (isCurrentYear) {
    return (
      <FormattedDate
        value={displayDate}
        month="short"
        day="numeric"
      />
    );
  }

  return (
    <FormattedDate
      value={displayDate}
      year="numeric"
      month="numeric"
      day="numeric"
    />
  );
};

DateComponent.propTypes = {
  date: PropTypes.string.isRequired,
};

export default DateComponent;
