import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import Empty from 'components/Empty';
import * as keyset from './MailList.i18n';

const i18n = createI18N(keyset);
const i18nFolderNoMails = i18n('folderNoMails');
const i18nSearchNoMails = i18n('searchNoMails');

const CONFIG = {
  FOLDER: {
    text: i18nFolderNoMails,
    icon: 'mail_outline',
  },
  SEARCH: {
    text: i18nSearchNoMails,
    icon: 'search',
  },
};

const VIEW = {
  FOLDER: 'FOLDER',
  SEARCH: 'SEARCH',
};

const MailListEmpty = ({ view }) => <Empty {...CONFIG[view]} />;

MailListEmpty.propTypes = {
  view: PropTypes.string,
};

MailListEmpty.defaultProps = {
  view: 'FOLDER',
};

MailListEmpty.VIEW = VIEW;

export default MailListEmpty;
