/*
eslint-disable
jsx-a11y/click-events-have-key-events,
jsx-a11y/no-static-element-interactions,
*/

import * as React from 'react';
import cx from 'classnames';
import createI18N, { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import * as keyset from './MailList.i18n';
import css from './MailListItem.modules.scss';

const i18n = createI18N(keyset);
const i18nRaw = createI18NRaw(keyset);

interface Props {
  className?: string;
  client: any;
  onClick: (any) => void;
}

const renderAccount = ({ id, clientId, login, name }: any) =>
  login || name || (clientId && `c:${clientId}`) || (id && `a:${id}`);

const Client = (props: Props) => {
  const { className, client, onClick } = props;

  return (
    <span className={className}>
      <span
        onClick={e => {
          e.stopPropagation();
          const selection = window.getSelection();
          if (!selection || selection.isCollapsed) {
            onClick(client);
          }
        }}
        className={cx(css.infoItem, css.clientData)}
        title={i18n('client', { name: client.login })}
      >
        <i className="material-icons">person</i>
        <span className={css.title}>{renderAccount(client)}</span>
      </span>
      {client.agencyLogin && (
        <span className={cx(css.infoItem, css.subClientData)}>
          {i18nRaw('subclient', {
            name: <span className={css.agency}>{client.agencyLogin}</span>,
          })}
        </span>
      )}
    </span>
  );
};

Client.defaultProps = {
  className: undefined,
};

export default Client;
