import React from 'react';
import { Field } from 'redux-form';
import CheckBox from 'lego/redux-form/CheckBox';
import createI18N from '@yandex-int/i18n';
import * as keyset from './MailList.i18n';
import css from './styles.modules.scss';

const i18nGroupByTopic = createI18N(keyset)('groupByTopic');

const MailListSettings = () => (
  <div className={css.MailListSettings}>
    <Field name="thread" component={CheckBox}>
      {i18nGroupByTopic}
    </Field>
  </div>
);

export default MailListSettings;
