import React from 'react';
import PropTypes from 'prop-types';
import { ImperativePopup } from '@crm/components/dist/lego2/Popup';
import Folders from '../Folders';
import css from './styles.modules.scss';

const MoveToFolder = (props) => {
  const { children, onClick } = props;

  const content = (popupBag) => (
    <Folders
      popupClassName={css.popup}
      className={css.treeView}
      labelClassName={css.treeView__label}
      name="MOVE_TO_FOLDER"
      apiDefaultSlug=""
      onClick={(...args) =>
        onClick(...args).then((data) => {
          popupBag.hide();
          return data;
        })
      }
      view="popup"
      showToolbar
      toggleButtons
    />
  );

  return (
    <ImperativePopup content={content} toggle={() => children} directions="bottom" padding="s" />
  );
};

MoveToFolder.propTypes = {
  children: PropTypes.node.isRequired,
  onClick: PropTypes.func.isRequired,
};

export default MoveToFolder;
