import * as React from 'react';
import MailFormCommon, { MailFormCommonProps } from 'modules/newMail';
import Panel from 'modules/panel';
import { Position } from '@crm/components/dist/Panel';
import cx from 'classnames';
import createI18N from '@yandex-int/i18n';
import { PanelFiles, PanelEntity } from 'modules/clientHistory';
import * as keyset from './NewMail.i18n';
import css from './style.module.css';

const i18n = createI18N(keyset);
const i18nAccountHistory = i18n('accountHistory');
const i18nAccountFiles = i18n('accountFiles');

interface OwnProps {
  accountId?: number;
}

type Props = MailFormCommonProps & OwnProps;

const NewMail: React.FC<Props> = (props) => {
  const { accountId, className, ...mailFormCommonProps } = props;
  const panels = accountId
    ? [
        {
          id: 'activity',
          title: i18nAccountHistory,
          content: (
            <div className={css.clientHistoryWrap}>
              <PanelEntity
                key={accountId}
                param={{ clientId: accountId }}
                name="activity"
                loadOnMount
              />
            </div>
          ),
          keepMount: true,
          padding: false,
        },
        {
          id: 'files',
          title: i18nAccountFiles,
          content: (
            <div className={css.clientHistoryWrap}>
              <PanelFiles
                key={accountId}
                param={{ clientId: accountId }}
                name="files"
                loadOnMount
                showTitle={false}
              />
            </div>
          ),
          keepMount: true,
          padding: false,
        },
      ]
    : [];

  const mailFormClassName = cx(className, css.mailForm);

  return (
    <div className={css.wrap}>
      <MailFormCommon {...mailFormCommonProps} className={mailFormClassName} />
      {!!panels.length && <Panel name="newMail/panel" position={Position.Right} panels={panels} />}
    </div>
  );
};

export default NewMail;
