import React, { createElement } from 'react';
import { Field } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import cx from 'classnames';
import modalRelation from 'utils/modalRelation';
import TextInput from 'lego/redux-form/TextInput';
import * as keyset from './Search.i18n';
import css from './styles.modules.scss';
import Filters from './SearchFilters';
import FiltersRequest from './SearchFiltersRequest';
import FiltersIssue from './SearchFiltersIssue';
import FilterToggle from './components/FilterToggle';

const i18n = createI18N(keyset);
const i18nClose = createI18N(commonKeyset)('close');
const i18nInputPlaceholder = i18n('inputPlaceholder');
const i18nSubmitButton = i18n('submitButton');
const i18nSearchWithoutFilters = i18n('searchWithoutFilters');

const COMPONENTS = {
  default: Filters,
  request: FiltersRequest,
  issue: FiltersIssue,
};

const Search = React.forwardRef(
  (
    {
      onFocusInput,
      showFilters,
      withFilters,
      change,
      handleSubmit,
      className,
      type,
      showClose,
      onCancel,
      module,
      fieldsAccess,
    },
    ref,
  ) => {
    return (
      <form
        ref={ref}
        className={cx(className, css.search, { [css.search_focus]: showFilters })}
        onSubmit={handleSubmit}
      >
        <div className={css.toolbar}>
          <Field
            className={css.input}
            name="text"
            placeholder={i18nInputPlaceholder}
            component={TextInput}
            onFocus={onFocusInput}
            pin="round-clear"
            data-testid="search-input"
          />
          <FilterToggle />
          <Button
            data-testid="search-Button"
            view="action"
            size="s"
            type="submit"
            pin="brick-round"
          >
            {i18nSubmitButton}
          </Button>
          {showClose && (
            <Button view="default" size="s" onClick={onCancel} title={i18nClose}>
              &#x2715;
            </Button>
          )}
        </div>
        {showFilters &&
          (!withFilters ? (
            <span className={css.filters}>{i18nSearchWithoutFilters}</span>
          ) : (
            createElement(COMPONENTS[type], {
              change,
              className: css.filters,
              module,
              fieldsAccess,
            })
          ))}
      </form>
    );
  },
);

Search.defaultProps = {
  type: 'default',
};

export default modalRelation(Search);
