import React from 'react';
import cx from 'classnames';
import css from './styles.modules.scss';

const FieldWrap = ({ children, label, className }) => {
  if (label) {
    return (
      <div className={cx(css.row, className)}>
        <div className={css.label}>
          { label }
        </div>
        <div className={css.field}>
          { children }
        </div>
      </div>
    );
  }

  return (
    <div className={cx(css.row, className)}>
      { children }
    </div>
  );
};

export default FieldWrap;
