import React from 'react';
import cx from 'classnames';
import { cnTheme } from '@yandex-lego/components/Theme';
import { crmTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import PropTypes from 'prop-types';
import { Field, FieldArray } from 'redux-form';
import TreeInput from 'lego/redux-form/TreeInputOld';
import FieldDateRange from 'requestForms/components/FieldDateRange';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Select from 'lego/redux-form/Select';
import TextInputWithButton from 'lego/redux-form/TextInputWithButton';
import ButtonCheckbox from 'lego/redux-form/ButtonCheckbox';
import { TagsField as Tags, apiMail as apiTags } from 'modules/tags';
import { ModalForm as ClientModal } from 'modules/clientSelectForm';
import * as keyset from './Search.i18n';
import { IconAttachment, IconImportant, IconUnread } from '../Icons';
import FieldWrap from './SearchField';
import css from './styles.modules.scss';
import getAccountSearchStr from '../../utils/getAccountSearchStr';

const i18n = createI18N(keyset);
const commonI18n = createI18N(commonKeyset);
const i18nSearchByEmail = i18n('searchByEmail');
const i18nSearchByFrom = i18n('searchByFrom');
const i18nSearchByTo = i18n('searchByTo');
const i18nSearchBySubject = i18n('searchBySubject');
const i18nSearchByBody = i18n('searchByBody');
const i18nAllFolders = i18n('allFolders');
const i18nUnread = i18n('unread');
const i18nImportant = i18n('important');
const i18nWithFiles = i18n('withFiles');
const i18nLoginOrClientId = i18n('loginOrClientId');
const i18nChoose = commonI18n('choose');

const scope = [
  { value: 'any', content: i18nSearchByEmail },
  { value: 'from', content: i18nSearchByFrom },
  { value: 'to', content: i18nSearchByTo },
  { value: 'subject', content: i18nSearchBySubject },
  { value: 'bodyText', content: i18nSearchByBody },
];

const Filters = ({ className, change }) => (
  <div className={cx(className, cnTheme({ root: crmTheme.root }))}>
    <FieldWrap>
      <Field
        component={TreeInput}
        name="folderId"
        size="xs"
        mode="radio"
        className={css.treeSelect}
        defaultValueText={i18nAllFolders}
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        name="scope"
        component={Select}
        size="xs"
        className={css.width_full}
        componentClassName={css.width_full}
        width="max"
        options={scope}
        hasEmptyValue={false}
        defaultValueIndex={0}
      />
    </FieldWrap>
    <div className={css.fastFilters}>
      <Field name="onlyNew" component={ButtonCheckbox} size="xs" pin="round-brick">
        <IconUnread />
        &nbsp;{i18nUnread}
      </Field>
      <Field name="important" component={ButtonCheckbox} size="xs" pin="clear-clear">
        <IconImportant />
        &nbsp;{i18nImportant}
      </Field>
      <Field name="attaches" component={ButtonCheckbox} size="xs" pin="brick-round">
        <IconAttachment />
        &nbsp;{i18nWithFiles}
      </Field>
    </div>
    <FieldWrap>
      <ClientModal
        name="SEARCH_CLIENT"
        onSubmit={(client) => {
          change('clientIdLogin', getAccountSearchStr(client));
        }}
      >
        {(modal, open) => (
          <Field
            name="clientIdLogin"
            className={css.width_full}
            componentClassName={css.width_full}
            component={TextInputWithButton}
            placeholder={i18nLoginOrClientId}
            onClick={open}
            size="xs"
            buttonLabel={i18nChoose}
          >
            {modal}
          </Field>
        )}
      </ClientModal>
    </FieldWrap>
    <FieldDateRange
      className={`${css.row} ${css.row_date}`}
      fieldClassName={css.date}
      startName="from"
      endName="to"
      size="xs"
      popupPosition={['left', 'right']}
    />
    <FieldWrap>
      <FieldArray
        name="tagIds"
        component={Tags}
        props={{
          getTags: () => apiTags.get(),
        }}
      />
    </FieldWrap>
  </div>
);

Filters.propTypes = {
  className: PropTypes.string,
  change: PropTypes.func.isRequired,
};

Filters.defaultProps = {
  className: undefined,
};

export default Filters;
