import React from 'react';
import PropTypes from 'prop-types';
import { Field, FieldArray } from 'redux-form';
import Select from 'lego/redux-form/Select';
import TextInput from 'lego/redux-form/TextInput';
import SuggestStaffInPopup2 from 'lego/redux-form/SuggestStaffInPopup2';
import FieldTreeSelect from 'requestForms/components/FieldTreeSelect';
import FieldDateRange from 'requestForms/components/FieldDateRange';
import TextInputWithButton from 'lego/redux-form/TextInputWithButton';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { ModalForm as ClientModal } from 'modules/clientSelectForm';
import { TagsField as Tags, apiMail as apiTags } from 'modules/tags';
import * as keyset from './Search.i18n';
import FieldWrap from './SearchField';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const commonI18n = createI18N(commonKeyset);
const i18nCategory = i18n('category');
const i18nAll = i18n('all');
const i18nAuthor = i18n('author');
const i18nAny = i18n('any');
const i18nExecutor = i18n('executor');
const i18nQueue = i18n('queue');
const i18nSearchByEmail = i18n('searchByEmail');
const i18nSearchByFrom = i18n('searchByFrom');
const i18nSearchByTo = i18n('searchByTo');
const i18nSearchBySubject = i18n('searchBySubject');
const i18nSearchByBody = i18n('searchByBody');
const i18nStatus = i18n('status');
const i18nStatusOpen = i18n('statusOpen');
const i18nStatusInProgress = i18n('statusInProgress');
const i18nStatusClosed = i18n('statusClosed');
const i18nStatusDeferred = i18n('statusDeferred');
const i18nResolution = i18n('resolution');
const i18nResolutionResolved = i18n('resolutionResolved');
const i18nResolutionOnCall = i18n('resolutionOnCall');
const i18nResolutionDup = i18n('resolutionDup');
const i18nResolutionSpam = i18n('resolutionSpam');
const i18nResolutionWaiting = i18n('resolutionWaiting');
const i18nResolutionModeration = i18n('resolutionModeration');
const i18nResolutionNoReply = i18n('resolutionNoReply');
const i18nResolutionInfo = i18n('resolutionInfo');
const i18nResolutionIncorrect = i18n('resolutionIncorrect');
const i18nLoginOrClientId = i18n('loginOrClientId');
const i18nChoose = commonI18n('choose');
const i18nInn = i18n('inn');
const i18nContractNum = i18n('contractNum');

const Filters = ({ className, change }) => (
  <div className={className}>
    <FieldWrap>
      <Field
        labelPrefix={i18nCategory}
        labelWidth={100}
        component={FieldTreeSelect}
        name="categoryIds"
        size="s"
        mode="hierarchy-check"
        endpoint="/view/support/category/list/all"
        defaultValueText={i18nAll}
        props={{ name: 'categoryId' }}
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        labelPrefix={i18nAuthor}
        labelWidth={100}
        component={SuggestStaffInPopup2}
        variant={SuggestStaffInPopup2.StaffSuggestVariant.UsersOnly}
        onlyUserHadAnyRole
        name="authorIds"
        size="xs"
        defaultValueText={i18nAny}
        width="max"
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        labelPrefix={i18nExecutor}
        labelWidth={100}
        component={SuggestStaffInPopup2}
        variant={SuggestStaffInPopup2.StaffSuggestVariant.UsersOnly}
        onlyUserHadAnyRole
        name="ownerIds"
        size="xs"
        defaultValueText={i18nAny}
        width="max"
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        labelPrefix={i18nQueue}
        labelWidth={100}
        component={FieldTreeSelect}
        name="queueIds"
        size="s"
        mode="hierarchy-check"
        endpoint="/view/support/queue/list/all"
        props={{ name: 'queueId' }}
        defaultValueText={i18nAll}
        backendDataType="array"
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        name="scope"
        component={Select}
        size="xs"
        width="max"
        className={css.width_full}
        componentClassName={css.width_full}
        hasEmptyValue={false}
        options={[
          { value: 'any', content: i18nSearchByEmail },
          { value: 'from', content: i18nSearchByFrom },
          { value: 'to', content: i18nSearchByTo },
          { value: 'subject', content: i18nSearchBySubject },
          { value: 'bodyText', content: i18nSearchByBody },
        ]}
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        name="stateIds"
        component={Select}
        size="xs"
        width="max"
        className={css.width_full}
        componentClassName={css.width_full}
        placeholder={i18nStatus}
        hasEmptyValue={false}
        options={[
          { value: '2', content: i18nStatusOpen },
          { value: '3', content: i18nStatusInProgress },
          { value: '4', content: i18nStatusClosed },
          { value: '5', content: i18nStatusDeferred },
        ]}
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        name="resolutions"
        component={Select}
        size="xs"
        width="max"
        className={css.width_full}
        componentClassName={css.width_full}
        placeholder={i18nResolution}
        hasEmptyValue={false}
        options={[
          { value: 'resolved', content: i18nResolutionResolved },
          { value: 'oncall', content: i18nResolutionOnCall },
          { value: 'duplicate', content: i18nResolutionDup },
          { value: 'spam', content: i18nResolutionSpam },
          { value: 'pendingAdjacenter', content: i18nResolutionWaiting },
          { value: 'moderation', content: i18nResolutionModeration },
          { value: 'noreply', content: i18nResolutionNoReply },
          { value: 'requiredInfo', content: i18nResolutionInfo },
          { value: 'uncorrect', content: i18nResolutionIncorrect },
        ]}
      />
    </FieldWrap>
    <FieldWrap>
      <ClientModal
        name="SEARCH_CLIENT"
        onSubmit={client => {
          change('clientIdLogin', client.login);
        }}
      >
        {(modal, open) => (
          <Field
            name="clientIdLogin"
            className={css.width_full}
            componentClassName={css.width_full}
            component={TextInputWithButton}
            placeholder={i18nLoginOrClientId}
            size="s"
            onClick={open}
            buttonLabel={i18nChoose}
          >
            {modal}
          </Field>
        )}
      </ClientModal>
    </FieldWrap>
    <FieldWrap>
      <Field
        name="inn"
        component={TextInput}
        size="xs"
        className={css.width_full}
        componentClassName={css.width_full}
        placeholder={i18nInn}
      />
    </FieldWrap>
    <FieldWrap>
      <Field
        name="contractNum"
        component={TextInput}
        size="xs"
        className={css.width_full}
        componentClassName={css.width_full}
        placeholder={i18nContractNum}
      />
    </FieldWrap>
    <FieldDateRange
      className={css.row}
      fieldClassName={css.date}
      startName="from"
      endName="to"
      size="xs"
    />
    <FieldWrap>
      <FieldArray
        name="tagIds"
        component={Tags}
        props={{
          getTags: () => apiTags.get(),
        }}
      />
    </FieldWrap>
  </div>
);

Filters.propTypes = {
  className: PropTypes.string,
  change: PropTypes.func.isRequired,
};

Filters.defaultProps = {
  className: undefined,
};

export default Filters;
