import React from 'react';
import { OptimizedTags, TagAuthor, Tag, apiMail as apiTags } from 'modules/tags';
// import destroyDriver from 'utils/destroyDriver';

const MailTags = props => {
  const {
    className,
    size,
    name,
    id,
    tags,
    canEdit,
    destroyOnUnmount,
    withRedux,
    asyncInit,
    needInit,
  } = props;

  if (!name) return null;

  return (
    <OptimizedTags
      className={className}
      size={size}
      name={name}
      getTags={() => apiTags.get()}
      addTag={id ? tagId => apiTags.add(id, tagId) : undefined}
      removeTag={id ? tagId => apiTags.remove(id, tagId) : undefined}
      tags={tags}
      tagComponent={id ? TagAuthor : Tag}
      canEdit={canEdit}
      destroyOnUnmount={destroyOnUnmount}
      asyncInit={asyncInit}
      needInit={needInit}
      withRedux={withRedux}
      enableReinitialize
    />
  );
};

MailTags.defaultProps = {
  withRedux: true,
};

export default MailTags;
