import React, { useContext } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import createI18N from '@yandex-int/i18n';
import { DeviceType, MediaMatchContext } from 'components/MediaMatch';
import { Route, Switch } from 'react-router-dom';
import Icon from 'lego/components/Icon';
import cx from 'classnames';
import * as keyset from './Toolbar.i18n';
import ActionButton from '../../modules/mailPreview/components/Actions/ActionButton';
import css from './Toolbar.module.css';

const i18n = createI18N(keyset);
const i18nTitle = i18n('title');
const i18nNewMail = i18n('newMail');
const i18nCheckMails = i18n('checkMails');
const i18nToMailsList = i18n('toMailsList');

interface Props {
  onNewMail: () => void;
  onUpdate: () => void;
}

const ToolbarMail: React.FC<Props> = ({ onNewMail, onUpdate }) => {
  const deviceType = useContext(MediaMatchContext);

  const isMobile = deviceType === DeviceType.Tablet || deviceType === DeviceType.Phone;

  const routes: React.ReactNode[] = [];

  if (isMobile) {
    routes.push(
      <Route
        key="mail"
        path={['/mail/mailId/:mailId', '/mail/folderId/:folderId/mailId/:mailId']}
        component={({ match }) => (
          <Button
            className={css.toMails}
            type="link"
            url={`#/mail${match.params.folderId ? `/folderId/${match.params.folderId}` : ''}`}
            view="clear"
            size="s"
            icon={(cls) => (
              <Icon
                className={cx(cls, css.toMails__icon)}
                pack={Icon.PACKS.MATERIAL}
                icon="arrow_back"
              />
            )}
          >
            {i18nToMailsList}
          </Button>
        )}
      />,
    );
  }

  routes.push(
    <Route key="list">
      <ActionButton iconColor="blue" onClick={onNewMail} icon="mainToolbarCompose">
        {i18nNewMail}
      </ActionButton>
      <ActionButton iconColor="green" onClick={onUpdate} icon="mainToolbarRefresh">
        {i18nCheckMails}
      </ActionButton>
    </Route>,
  );

  return (
    <div className={css.root}>
      <div className={css.title}>{i18nTitle}</div>
      <Switch>{routes}</Switch>
    </div>
  );
};

export default ToolbarMail;
