import { connect } from 'react-redux';
import { formValueSelector } from 'redux-form';
import FieldEmail from 'requestForms/components/FieldEmail';
import get from 'lodash/get';

export default connect(
  (state, props) => {
    const formDataSelector = formValueSelector(props.meta.form);

    return {
      minSearchStringLength: 0,
      extraFetchParam: {
        accountId: get(formDataSelector(state, 'account'), 'id'),
      },
    };
  },
)(FieldEmail);
