import { getState as getTreeState } from 'containers/TreeSelect/selectors';
import { connect } from 'react-redux';
import get from 'lodash/get';
import { getActiveFilter, setFilter, removeFilter } from 'modules/filter';
import FastFiltersDumb from '../components/FastFilters';
import { NAME } from '../constants';

const mapState = (state) => {
  const foldersTree = getTreeState(state, NAME);
  // const folders = foldersTree && foldersTree.list;
  // const currentFolder = foldersTree && foldersTree.selected;
  // const filtersCountersCurrent = folders && currentFolder ?
  //   folders[currentFolder].counter : undefined;
  return {
    filtersCounters: get(foldersTree, 'data.summaryCounter'),
    // filtersCountersCurrent,
    filterActive: get(getActiveFilter(state, NAME), 'key'),
  };
};

const mapDispatch = dispatch => ({
  switchFilter: filter => dispatch(setFilter(NAME, {
    key: filter,
    value: {
      [filter]: true,
      folderId: -1,
    },
    showFolder: true,
    autoUpdate: false,
  })),
  removeFilter: filter => dispatch(removeFilter(NAME, filter)),
});

const mapMerge = (stateProps, dispatchProps, ownProp) => ({
  ...ownProp,
  ...stateProps,
  ...dispatchProps,
  switchFilter: (filter) => {
    if (stateProps.filterActive === filter) {
      dispatchProps.removeFilter(filter);
    } else {
      dispatchProps.switchFilter(filter);
    }
  },
});

export default connect(mapState, mapDispatch, mapMerge)(FastFiltersDumb);
