import { connect } from 'react-redux';
import { DropTarget } from 'react-dnd';
import flowRight from 'lodash/flowRight';
import FolderNode from '../components/Folders/FolderNode';
import { moveToFolder } from '../modules/mailPreview/actions';

const folderTarget = {
  drop(props, monitor) {
    const mail = monitor.getItem();
    props.moveToFolder(mail.id, props.id);
  },
};

function collect(connectDnd, monitor) {
  return {
    connectDropTarget: connectDnd.dropTarget(),
    isOver: monitor.isOver(),
  };
}

const enhance = flowRight([
  connect(null, { moveToFolder }),
  DropTarget('MAIL', folderTarget, collect),
]);

export default enhance(FolderNode);
