import { connect } from 'react-redux';
import propsAdapter from 'hoc/propsAdapter';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import MailForm from '../components/NewMail';
import { Inline as Account } from '../modules/account';
import { loadDraft, reply, newMail } from '../api';
import { save } from '../actions';
import EmailInput from './EmailInput';

const i18nAccount = createI18N(commonKeyset)('account');

const fields = {
  from: true,
  to: true,
  cc: true,
  bcc: true,
  subject: true,
  tags: true,
  files: true,
  delayedDate: true,
  important: true,
  opportunities: true,
};

const ReduxFormAccount = propsAdapter({
  adapter: (props) => ({
    onChange: props.input.onChange,
    account: props.input.value,
    fetchClient: true,
  }),
})(Account);

const customFieldsTop = [
  {
    label: i18nAccount,
    name: 'account',
    getValue: (account) => ({ accountId: account && account.id }),
    component: ReduxFormAccount,
  },
];

const mapState = () => ({
  customFieldsTop,
  fields,
  EmailInput,
  loadOnMount: true,
  isPreventUnload: true,
});

const mapDispatch = (dispatch) => ({
  onSubmit: (values) => dispatch(save(values)),
  loadNew: newMail,
  loadDraft,
  loadReply: reply,
});

export default connect(mapState, mapDispatch)(MailForm);
