import React from 'react';
import { getFormValues } from 'redux-form';
import { connect } from 'react-redux';
import TitleChain from 'modules/heading';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { MODULE_NAME_NEW } from '../constants';
import NewMail from './NewMail';
import css from '../components/Mail/Mail.module.css';

const i18nClose = createI18N(commonKeyset)('close');

const reduxFormName = 'NewMail';
const getValues = getFormValues(reduxFormName);

const mapState = (state, props) => {
  const values = getValues(state);
  const accountId = values && values.account && values.account.id;
  return {
    name: reduxFormName,
    buttonTextCancel: i18nClose,
    accountId,
    ...props.location.state,
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmitSuccess: () => props.restoreLocation(true),
  onCancel: props.restoreLocation,
});

const NewMailRouter = props => {
  const { loadArgs, ...propsPassThrough } = props;
  const extendedLoadArgs = { ...loadArgs, ...props.location.query };
  return (
    <React.Fragment>
      <TitleChain>{MODULE_NAME_NEW}</TitleChain>
      <NewMail className={css.newMail} {...propsPassThrough} loadArgs={extendedLoadArgs} />
    </React.Fragment>
  );
};

export default connect(mapState, mapDispatch)(NewMailRouter);
