import { connect } from 'react-redux';
import { history } from 'appHistory';
import browserWindow from 'utils/browserWindow';
import { update } from '../actions';
import Toolbar from '../components/Toolbar';

const mapDispatch = dispatch => ({
  onNewMail: event => {
    if (event && (event.metaKey || event.altKey)) {
      browserWindow.open('/mail/new');
    } else {
      history.push('/mail/new');
    }
  },
  onUpdate: () => {
    dispatch(update());
  },
});

export default connect(null, mapDispatch)(Toolbar);
