import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Button from '@crm/components/dist/lego2/Button';
import PreviewAccountBlock from 'components/PreviewValue/PreviewAccountBlock';
import cx from 'classnames';
import * as keyset from '../account.i18n';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const i18nEdit = i18n('edit');
const i18nChoose = i18n('choose');
const i18nAccount = createI18N(commonKeyset)('account');

const Account = ({
  className,
  account,
  openModal,
  modal,
  label,
  headerClassName,
  bodyClassName,
  actionClassName,
  readonly,
}) => (
  <div className={cx(className, css.root)}>
    <div className={cx(headerClassName, css.row)}>
      {label}
      {!readonly && (
        <span className={cx(actionClassName, css.change)}>
          <Button onClick={openModal} size="xs" view="pseudo">
            {account ? i18nEdit : i18nChoose}
          </Button>
        </span>
      )}
    </div>
    <PreviewAccountBlock className={bodyClassName} value={account} />
    {modal}
  </div>
);

Account.propTypes = {
  className: PropTypes.string,
  headerClassName: PropTypes.string,
  bodyClassName: PropTypes.string,
  actionClassName: PropTypes.string,
  account: PropTypes.instanceOf(Object),
  openModal: PropTypes.func.isRequired,
  modal: PropTypes.node.isRequired,
  label: PropTypes.string,
  readonly: PropTypes.bool,
};

Account.defaultProps = {
  className: undefined,
  headerClassName: undefined,
  bodyClassName: undefined,
  actionClassName: undefined,
  account: undefined,
  label: i18nAccount,
  readonly: false,
};

export default Account;
