import React from 'react';
import ClientExternalLinks from 'components/ClientExternalLinks/index';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import cx from 'classnames';
import Button from '@crm/components/dist/lego2/Button';
import * as keyset from '../account.i18n';
import css from './styles.modules.scss';

const i18n = createI18N(keyset);
const i18nEdit = i18n('edit');
const i18nChoose = createI18N(commonKeyset)('choose');

const Account = ({ className, account, openModal, modal }) => (
  <div className={cx(className, css.account_inline)}>
    {account ? (
      [
        <div key="name" className={css.account__name}>
          {account.info.name} ({account.info.login})
        </div>,
        <div key="actions" className={css.account__actions}>
          <a tabIndex="0" onClick={openModal} className={css.change}>
            {i18nEdit}
          </a>
        </div>,
        <ClientExternalLinks className={css.account__externalLinks} key="links" client={account} />,
      ]
    ) : (
      <Button size="s" onClick={openModal}>
        {i18nChoose}
      </Button>
    )}
    {modal}
  </div>
);

Account.defaultProps = {
  account: undefined,
};

export default Account;
