import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { toggle } from 'containers/Modal';
import { ModalForm as ClientModal } from 'modules/clientSelectForm';
import { loadClient as apiLoadClient } from './../api';

const mapState = (state, props) => ({
  name: `mail:account:${props.mailId}`,
});

const mapDispatch = (dispatch, props) => ({
  openModal: () => dispatch(toggle(`mail:account:${props.mailId}`)),
});

/**
 * @param {boolean} [config.fetchClient=false] - load client after select in table
 * */
const withModal = config => (WrappedComponent) => {
  const WithModal = ({ fetchClient, searchEmail, ...props }) => {
    let onChange = props.onChange;
    if (fetchClient) {
      onChange = client => apiLoadClient(client.id).then(props.onChange);
    }

    return (
      <WrappedComponent
        modal={
          <ClientModal
            name={`mail:account:${props.mailId}`}
            onSubmit={onChange}
            defaultSearchKey={searchEmail && 'email'}
            defaultSearchValue={searchEmail}
          />
        }
        {...props}
      />
    );
  };

  WithModal.defaultProps = {
    fetchClient: false,
    searchEmail: undefined,
    ...config,
  };

  WithModal.propTypes = {
    fetchClient: PropTypes.bool,
    searchEmail: PropTypes.string,
  };

  return connect(mapState, mapDispatch)(WithModal);
};

export default withModal;
