import { ItemReducer } from 'containers/InfiniteList';
import * as aTypes from './actionTypes';

ItemReducer.injectBehaviors({
  [aTypes.THREAD_TOGGLE_REQUEST](state) {
    return {
      ...state,
      isThreadFetch: true,
    };
  },
  [aTypes.THREAD_TOGGLE_RECEIVE](state) {
    return {
      ...state,
      isThreadLoad: !state.isThreadLoad,
      isThreadFetch: false,
    };
  },
  [aTypes.THREAD_TOGGLE_FAIL](state) {
    return {
      ...state,
      isThreadFetch: false,
    };
  },
});
