import { baseCallApi } from 'api/common';
import { NAME as CONTEXT } from '../../constants';
import * as aTypes from './actionTypes';

export const load = mailId => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/view/mail',
    data: { mailId },
  },
  // promise: baseCallApi({ url: '/view/mail', data: { mailId }, global: false }),
  actions: [aTypes.LOAD_REQUEST, aTypes.LOAD_RECEIVE, aTypes.LOAD_FAIL],
  meta: { name: mailId },
});

export const spam = (mailId, isSpam) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/spam',
    data: { mailId, isSpam },
  },
  actions: [aTypes.SPAM_REQUEST, aTypes.SPAM_RECEIVE, aTypes.SPAM_FAIL],
  meta: { name: mailId },
});

export const moveToFolder = (mailId, folderId) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/move',
    data: { folderId, mailId },
  },
  actions: [
    aTypes.MOVE_TO_FOLDER_REQUEST,
    aTypes.MOVE_TO_FOLDER_RECEIVE,
    aTypes.MOVE_TO_FOLDER_FAIL,
  ],
  meta: { name: mailId },
});

export const remove = mailId => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/remove',
    data: { mailId },
  },
  actions: [aTypes.REMOVE_REQUEST, aTypes.REMOVE_RECEIVE, aTypes.REMOVE_FAIL],
  meta: { name: mailId },
});

export const commentSave = (mailId, comment) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/comment/save',
    data: comment,
  },
  actions: [aTypes.COMMENT_SAVE_REQUEST, aTypes.COMMENT_SAVE_RECEIVE, aTypes.COMMENT_SAVE_FAIL],
  meta: { name: mailId },
});

export const commentRemove = (mailId, id) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/comment/delete',
    data: { commentId: id },
  },
  actions: [
    aTypes.COMMENT_REMOVE_REQUEST,
    aTypes.COMMENT_REMOVE_RECEIVE,
    aTypes.COMMENT_REMOVE_FAIL,
  ],
  meta: { name: mailId },
});

export const setAccount = (mailId, accountId) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/setAccount',
    data: { mailId, accountId },
  },
  actions: [
    aTypes.ACCOUNT_CHANGE_REQUEST,
    aTypes.ACCOUNT_CHANGE_RECEIVE,
    aTypes.ACCOUNT_CHANGE_FAIL,
  ],
  meta: { name: mailId },
});

export const unread = (mailId, isUnread) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/unread',
    data: { mailId, isUnread },
  },
  actions: [aTypes.UNREAD_REQUEST, aTypes.UNREAD_RECEIVE, aTypes.UNREAD_FAIL],
  meta: { name: mailId },
});

export const setImportant = (mailId, flag) => ({
  type: 'FETCH',
  context: CONTEXT,
  args: {
    url: '/actions/mail/setImportant',
    data: {
      mailId,
      flag,
    },
  },
  actions: [aTypes.SET_IMPORTANT_REQUEST, aTypes.SET_IMPORTANT_RECEIVE, aTypes.SET_IMPORTANT_FAIL],
  meta: { name: mailId },
});

export const update = (mailId, updateObj) => ({
  type: aTypes.UPDATE,
  payload: updateObj,
  meta: { name: mailId },
});

export const addRequest = (mailId, request) => ({
  type: aTypes.ADD_REQUEST,
  payload: request,
  meta: { name: mailId },
});

export const destroy = mailId => ({ type: aTypes.DESTROY, meta: { name: mailId } });

export const checkKik = (mailId, accountId) => ({
  type: 'PROMISE',
  promise: baseCallApi({
    url: '/view/account/kik/exists',
    data: { mailId, accountId },
    global: false,
  }),
  actions: [aTypes.KIK_CHECK_REQUEST, aTypes.KIK_CHECK_RECEIVE, null],
  meta: { name: mailId, accountId },
});

export const hidePopup = mailId => ({
  type: aTypes.HIDE_FROM_POPUP,
  meta: { name: mailId },
});
