/* eslint-disable react/prefer-stateless-function */

import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from './actions.modules.scss';

// use class for support ref
const MailActionButton = React.forwardRef((props, ref) => (
  <Button
    ref={ref}
    className={css.button}
    view="clear"
    size="xs"
    onClick={props.onClick}
    icon={(cls) => (
      <Icon
        svg={props.icon}
        className={cx(cls, css.button__icon)}
        style={{ color: props.iconColor }}
      />
    )}
  >
    {props.text || props.children}
  </Button>
));

MailActionButton.propTypes = {
  onClick: PropTypes.func,
  iconColor: PropTypes.string,
  text: PropTypes.node,
  children: PropTypes.node,
  icon: PropTypes.string,
};

MailActionButton.defaultProps = {
  onClick: undefined,
  iconColor: undefined,
  text: undefined,
  children: undefined,
  icon: undefined,
};

export default MailActionButton;
